<?php

namespace App\Filament\Resources\UserResource\Pages;

use App\Filament\Resources\UserResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditUser extends EditRecord
{
    protected static string $resource = UserResource::class;




     protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('inactivar')
                ->label('Eliminar')
                ->visible(fn () => auth()->user()?->can('cliente.delete'))

                ->icon('heroicon-o-trash')
                ->requiresConfirmation()
                ->color('danger')
                ->action(function () {
                    $record = $this->getRecord();
                    $record->status = 0;
                    $record->save();

                    $this->redirect(UserResource::getUrl());
                }),
        ];
    }

    // protected function getHeaderActions(): array
    // {
    //     return [
    //         Actions\DeleteAction::make(),
    //     ];
    // }

    protected function getRedirectUrl(): string{
        return $this->getResource()::getUrl('index');
    }


    public function getTitle(): string
    {
        return 'Editar Usuario';
    }
}
