<?php

namespace App\Filament\Widgets;

use App\Models\DeviceControl;
use App\Models\User;
use EightyNine\FilamentAdvancedWidget\AdvancedStatsOverviewWidget as BaseWidget;
use EightyNine\FilamentAdvancedWidget\AdvancedStatsOverviewWidget\Stat;

class GeneralStatsOverviewWidget extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    protected function getStats(): array
    {
        $totalUsers = User::count();
        $clientUsers = User::whereHas('roles', function ($query) {
            $query->where('name', 'cliente');
        })->count();
        $totalDevices = DeviceControl::count();
        $activeDevices = DeviceControl::where('value', '!=', null)->count();

        $clientPercentage = $totalUsers > 0 ? ($clientUsers / $totalUsers) * 100 : 0;
        $activeDevicesPercentage = $totalDevices > 0 ? ($activeDevices / $totalDevices) * 100 : 0;

        return [
            Stat::make('Usuarios', number_format($totalUsers))
                ->icon('heroicon-o-user-group')
                ->iconColor('primary')
                ->color('primary')
                ->progress(100)
                ->description('Total registrados')
                ->descriptionIcon('heroicon-o-users', 'before'),

            Stat::make('Clientes', number_format($clientUsers))
                ->icon('heroicon-o-shopping-bag')
                ->iconColor('info')
                ->color('info')
                ->progress((int)$clientPercentage)
                ->description('Con rol cliente')
                ->descriptionIcon('heroicon-o-check-badge', 'before'),

            // Stat::make('Activos', number_format($activeDevices))
            //     ->icon('heroicon-o-power')
            //     ->iconColor('success')
            //     ->color('success')
            //     ->progress((int)$activeDevicesPercentage)
            //     ->description('Dispositivos activos')
            //     ->descriptionIcon('heroicon-o-bolt', 'before'),


            Stat::make('Dispositivos', number_format($totalDevices))
                ->icon('heroicon-o-cpu-chip')
                ->iconColor('warning')
                ->color('warning')
                ->progress(100)
                ->description('Microcontroladores')
                ->descriptionIcon('heroicon-o-cog', 'before'),
        ];
    }
}
