<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;


class ControlVariableType extends Model
{
    use HasFactory;

    protected $fillable = [
    'name',
    'slug',
    'example',
    'unit',
    'description',
    'variable_group_id',
    ];

    public function group()
    {
        return $this->belongsTo(VariableTypeGroup::class, 'variable_group_id');
    }


    protected static function booted()
    {
        static::creating(function ($type) {
            if (empty($type->slug)) {
                $type->slug = Str::slug($type->name);
            }
        });

        static::updating(function ($type) {
            if (empty($type->slug)) {
                $type->slug = Str::slug($type->name);
            }
        });
    }

    public function controls()
    {
        return $this->hasMany(DeviceControl::class, 'control_variable_type_id');
    }


}
