<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use App\Models\HouseUser;




class House extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'cell_phone',
        'address',
        'google_map',
        'house_numbre',
        'created_by',
        'code',
        'status',
        'url_key',
    ];




    public function creator(){
        return $this->belongsTo(User::class, 'created_by');
    }



   protected static function booted()
    {
        static::creating(function ($house) {
            if (empty($house->url_key)) {
                $house->url_key = (string) Str::uuid();
            }
            if (empty($house->code)) {
                $house->code = static::generateUniqueCode();
            }
        });
        static::updating(function ($house) {
        });
    }

    public function users()
{
    return $this->belongsToMany(User::class, 'house_user')
                ->withPivot('role', 'status', 'created_by')
                ->withTimestamps();
}

    public function house_user(){
        return $this->hasOne(\App\Models\House::class, 'house_id');
    }

    public function rooms()
    {
        return $this->hasMany(Room::class, 'house_id');
    }

    public function devices()
    {
        return $this->hasMany(Device::class);
    }

    public function model()
    {
        return $this->belongsTo(DeviceModel::class, 'device_model_id');
    }

    public function houses(): BelongsToMany
    {
        return $this->belongsToMany(House::class, 'house_user', 'user_id', 'house_id')
                    ->using(HouseUser::class)
                    ->withPivot(['role', 'status', 'created_by'])
                    ->withTimestamps();
    }



     protected static function generateUniqueCode(): string
    {
        do {
            $year = date('Y');
            $random = strtoupper(Str::random(5));
            $code = "DOM-{$year}-{$random}";
            $exists = static::where('code', $code)->exists();
        } while ($exists);

        return $code;
    }













}
