<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class HouseUser extends Model
{
    use HasFactory;

     protected $table = 'house_user';

    protected $fillable = [
        'user_id',
        'house_id',
        'role',
        'created_by',
        'status',

    ];

     protected $casts = [
        'role' => 'string',
    ];





     // Relación con el usuario asociado
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    // Relación con la casa asociada
    public function house()
    {
        return $this->belongsTo(House::class, 'house_id');
    }

    // Relación con el creador
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
