<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('houses', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('cell_phone');
            $table->string('house_numbre')->nullable();
            $table->string('address')->nullable();
            $table->string('google_map')->nullable();
            $table->uuid('url_key')->unique();
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade'); // Relación con el usuario creador
            $table->enum('status', ['active', 'inactive']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('houses');
    }
};
