<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('control_variable_types', function (Blueprint $table) {
            //

            $table->foreignId('variable_group_id')->nullable()->after('description')->constrained('variable_type_groups')->nullOnDelete();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('control_variable_types', function (Blueprint $table) {
            //
             $table->dropForeign(['variable_group_id']);
            $table->dropColumn('variable_group_id');
        });
    }
};
