<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('device_controls', function (Blueprint $table) {
            $table->id();
            $table->foreignId('device_id')->constrained()->onDelete('cascade');
            $table->string('name'); // Nombre de la cosa controlada
            $table->foreignId('control_variable_type_id')->constrained()->onDelete('cascade');
            $table->string('declaration')->nullable();
            $table->enum('permissions', ['read_only', 'read_write'])->default('read_write');
            $table->enum('update_policy', ['on_change', 'periodic'])->default('on_change');
            $table->unsignedInteger('update_threshold')->nullable();
            $table->json('sync_with')->nullable();
            $table->timestamp('start_at')->nullable();
            $table->timestamp('end_at')->nullable();
            $table->boolean('is_voice_controlled')->default(false);
            $table->string('voice_command')->nullable();
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('device_controls');
    }
};
