<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('widgets', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('type', ['interaction', 'visualization', 'notification']);
            $table->string('icon')->nullable(); // ej: "fa-lightbulb" o "mdi-thermometer"
            $table->json('config')->nullable(); // parámetros dinámicos (rango, colores, etc.)
            $table->text('description')->nullable(); // descripción opcional
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('widgets');
    }
};
