<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use App\Models\User;
use Carbon\Carbon;
app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = Carbon::now()->toDateTimeString();

        $permissions = [
            // Permisos de usuario
            ['name' => 'usuario.view'],
            ['name' => 'usuario.create'],
            ['name' => 'usuario.update'],
            ['name' => 'usuario.delete'],

            // Permisos de roles
            ['name' => 'role.view'],
            ['name' => 'role.create'],
            ['name' => 'role.update'],
            ['name' => 'role.delete'],

              // Permisos de hogar
            ['name' => 'hogar.view'],
            ['name' => 'hogar.create'],
            ['name' => 'hogar.update'],
            ['name' => 'hogar.delete'],

              // Permisos de hogar.user
            ['name' => 'hogar_usuario.user.view'],
            ['name' => 'hogar_usuario.user.create'],
            ['name' => 'hogar_usuario.user.update'],
            ['name' => 'hogar_usuario.user.delete'],

            // Permisos de ambiente
            ['name' => 'ambiente.view'],
            ['name' => 'ambiente.create'],
            ['name' => 'ambiente.update'],
            ['name' => 'ambiente.delete'],

            // Permisos de dispositivos
            ['name' => 'dispositivo.view'],
            ['name' => 'dispositivo.create'],
            ['name' => 'dispositivo.update'],
            ['name' => 'dispositivo.delete'],

            // Permisos de dispositivos_control

            ['name' => 'dispositivo_control.controls.view'],
            ['name' => 'dispositivo_control.controls.create'],
            ['name' => 'dispositivo_control.controls.update'],
            ['name' => 'dispositivo_control.controls.delete'],

            // Permisos de tipos_dispositvos
            ['name' => 'tipo_dispositivo.view'],
            ['name' => 'tipo_dispositivo.create'],
            ['name' => 'tipo_dispositivo.update'],
            ['name' => 'tipo_dispositivo.delete'],

            // Permisos de modelo_dispositivo
            ['name' => 'modelo_dispositivo.view'],
            ['name' => 'modelo_dispositivo.create'],
            ['name' => 'modelo_dispositivo.update'],
            ['name' => 'modelo_dispositivo.delete'],


               // Permisos de componentes
            ['name' => 'componentes.view'],
            ['name' => 'componentes.create'],
            ['name' => 'componentes.update'],
            ['name' => 'componentes.delete'],


        ];

        foreach ($permissions as $perm) {
            Permission::firstOrCreate(
                ['name' => $perm['name'], 'guard_name' => 'web'],
                ['created_at' => $now, 'updated_at' => $now]
            );
        }

        // Crear el rol Administrador
        $adminRole = Role::firstOrCreate(
            ['name' => 'admin'],
            ['guard_name' => 'web']
        );

        // Asignar todos los permisos creados al rol
        $adminRole->syncPermissions(Permission::whereIn('name', array_column($permissions, 'name'))->get());

        // Asignar rol al usuario con ID 1
        // Asignar rol al usuario con ID 1
            $user = User::find(1);
            $adminRole = Role::where('name', 'admin')->first();

            if ($user && $adminRole && !$user->hasRole($adminRole)) {
                $user->assignRole($adminRole);
            }


        $this->command->info('✅ Permisos, rol "Administrador" y asignación completados.');
    }
}
