<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\HomeDataController;
use Illuminate\Support\Facades\Hash;

use App\Models\User;



/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/login', function (Request $request) {
    // Validar campos de entrada
    $request->validate([
        'email' => 'required|email',
        'password' => 'required',
    ]);

    // Buscar usuario por email
    $user = User::where('email', $request->email)->first();

    // Validar existencia y contraseña
    if (! $user || ! Hash::check($request->password, $user->password)) {
        return response()->json([
            'message' => 'Credenciales incorrectas',
        ], 401);
    }

    // Verificar si el usuario está activo
    if ($user->status == 0) {
        return response()->json([
            'message' => 'El usuario está inactivo. Contacte al administrador.',
        ], 403);
    }

    // Crear token de acceso
    $token = $user->createToken('api_token')->plainTextToken;

    // Retornar respuesta con el token y los datos del usuario
    return response()->json([
        'token' => $token,
        'user' => [
            'id' => $user->id,
            'name' => $user->name,
            'email' => $user->email,
            'status' => $user->status,
        ],
    ], 200);
});

Route::middleware('auth:sanctum')->group(function () {
    Route::get('/user/homes', [HomeDataController::class, 'fullIndex']);
    Route::get('/user/homes-with-controls', [HomeDataController::class, 'homesWithControls']);
    Route::put('/device/update-value', [HomeDataController::class, 'updateDeviceControlValue']);
    
    //solo las casa 
    Route::get('/user/homesdomo', [HomeDataController::class, 'getUserHomes']);
    
    //ambienets
    Route::get('/user/rooms', [HomeDataController::class, 'getUserRooms']);
    
    Route::get('/device/get-value', [HomeDataController::class, 'getDeviceControlValue']);
    Route::get('/device/get-controls', [HomeDataController::class, 'getDeviceControls']);






});


