<?php
    use Filament\Support\Enums\IconPosition;
    use Filament\Support\Facades\FilamentView;

    $chartColor = $getChartColor() ?? 'gray';
    $descriptionColor = $getDescriptionColor() ?? 'gray';
    $descriptionIcon = $getDescriptionIcon();
    $descriptionIconPosition = $getDescriptionIconPosition();
    $url = $getUrl();
    $tag = $url ? 'a' : 'div';
    $dataChecksum = $generateDataChecksum();
    $iconPosition = $getIconPosition();

    $icon = $getIcon();
    $iconColor = match ($getIconColor()) {
        'primary' => 'text-primary-500',
        'secondary' => 'text-secondary-500',
        'success' => 'text-success-500',
        'danger' => 'text-danger-500',
        'warning' => 'text-warning-500',
        'info' => 'text-info-500',
        default => 'text-gray-500',
    };

    $iconClasses = "fi-wi-stats-overview-stat-icon h-8 w-8 {$iconColor}";
    $iconBackgroundColor = $iconHasBackgroundColor() ? match ($getIconBackgroundColor()) {
        'primary' => 'bg-primary-200 dark:bg-primary-950',
        'secondary' => 'bg-secondary-200 dark:bg-secondary-950',
        'success' => 'bg-success-200 dark:bg-success-950',
        'danger' => 'bg-danger-200 dark:bg-danger-950',
        'warning' => 'bg-warning-200 dark:bg-warning-950',
        'info' => 'bg-info-200 dark:bg-info-950',
        default => 'bg-gray-200 dark:bg-gray-950',
    } : '';

    $iconContainerClasses = "{$iconBackgroundColor} h-fit p-1 rounded-lg";

    $progress = $getProgress();
    $progressBarColor = $getProgressBarColor();
    $progressBarClasses = "fi-wi-stats-overview-stat-progress-bar h-full w-full rounded-lg {$progressBarColor}";

    $backgroundColor = match ($getBackgroundColor()) {
        'primary' => 'bg-primary-500',
        'secondary' => 'bg-secondary-500',
        'success' => 'bg-success-500',
        'danger' => 'bg-danger-500',
        'warning' => 'bg-warning-500',
        'info' => 'bg-info-500',
        default => ' bg-white dark:bg-gray-900',
    };
    $labelColor = match ($getLabelColor()) {
        'primary' => 'text-primary-500',
        'secondary' => 'text-secondary-500',
        'success' => 'text-success-500',
        'danger' => 'text-danger-500',
        'warning' => 'text-warning-500',
        'info' => 'text-info-500',
        default => 'text-gray-950 dark:text-white',
    };
    $valueColor = match ($getValueColor()) {
        'primary' => 'text-primary-600',
        'secondary' => 'text-secondary-600',
        'success' => 'text-success-600',
        'danger' => 'text-danger-600',
        'warning' => 'text-warning-600',
        'info' => 'text-info-600',
        default => 'text-gray-950 dark:text-white',
    };
    $descriptionColor = match ($getDescriptionColor()) {
        'primary' => 'text-primary-600',
        'secondary' => 'text-secondary-600',
        'success' => 'text-success-600',
        'danger' => 'text-danger-600',
        'warning' => 'text-warning-600',
        'info' => 'text-info-600',
        default => 'text-gray-950 dark:text-white',
    };

    $chartBorderColor = match ($getChartBorderColor()) {
        'primary' => 'text-primary-600 border-3',
        'secondary' => 'text-secondary-600 border-3',
        'success' => 'text-success-600 border-3',
        'danger' => 'text-danger-600 border-3',
        'warning' => 'text-warning-600 border-3',
        'info' => 'text-info-600 border-3',
        default => 'text-gray-600 border-3',
    };
    $chartBackgroundColor = match ($getChartBackgroundColor()) {
        'gray' => 'text-gray-100 dark:text-gray-800',
        default => 'text-custom-50 dark:text-custom-400/10',
    };

    $descriptionIconClasses = "fi-wi-stats-overview-stat-description-icon h-5 w-5 {$descriptionColor}";

    $descriptionIconStyles = \Illuminate\Support\Arr::toCssStyles([
        \Filament\Support\get_color_css_variables(
            $descriptionColor,
            shades: [500],
            alias: 'widgets::stats-overview-widget.stat.description.icon',
        ) => $descriptionColor !== 'gray',
    ]);
?>

<<?php echo $tag; ?>

    <?php if($url): ?> <?php echo e(\Filament\Support\generate_href_html($url, $shouldOpenUrlInNewTab())); ?> <?php endif; ?>
    <?php echo e($getExtraAttributeBag()->class([
        'fi-wi-stats-overview-stat relative rounded-xl p-6 shadow-sm ring-1 ring-gray-950/5 dark:ring-white/10 ' .
        $backgroundColor,
    ])); ?>>
    <div class="flex gap-y-2 gap-x-3">
        <!--[if BLOCK]><![endif]--><?php if($icon && $iconPosition === 'start'): ?>
            <div class="<?php echo e($iconContainerClasses); ?>">
                <?php if (isset($component)) { $__componentOriginalbfc641e0710ce04e5fe02876ffc6f950 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'filament::components.icon','data' => ['icon' => $icon,'class' => ''.e($iconClasses).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('filament::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($icon),'class' => ''.e($iconClasses).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950)): ?>
<?php $attributes = $__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950; ?>
<?php unset($__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbfc641e0710ce04e5fe02876ffc6f950)): ?>
<?php $component = $__componentOriginalbfc641e0710ce04e5fe02876ffc6f950; ?>
<?php unset($__componentOriginalbfc641e0710ce04e5fe02876ffc6f950); ?>
<?php endif; ?>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        <div class="flex-grow">
            <div class="flex items-center gap-x-2">
                <span class="fi-wi-stats-overview-stat-label text-sm font-medium <?php echo e($labelColor); ?>">
                    <?php echo e($getLabel()); ?>

                </span>
            </div>

            <div class="fi-wi-stats-overview-stat-value text-3xl font-semibold tracking-tight <?php echo e($valueColor); ?>">
                <?php echo e($getValue()); ?>

            </div>


            <!--[if BLOCK]><![endif]--><?php if(filled($progress)): ?>
                <div
                    class="w=full h-1 mt-3 mb-3 bg-gray-200 dark:bg-gray-800 rounded-lg <?php echo e($icon && $iconPosition === 'end' ? '-mr-[50px]' : '-ml-[50px]'); ?>">
                    <div class="<?php echo e($progressBarClasses); ?>" style="width: <?php echo e($progress); ?>%"></div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            <!--[if BLOCK]><![endif]--><?php if($description = $getDescription()): ?>
                <div
                    class="flex items-center gap-x-1 <?php echo e($icon && $iconPosition === 'end' ? '-mr-[50px]' : '-ml-[50px]'); ?>">
                    <!--[if BLOCK]><![endif]--><?php if($descriptionIcon && in_array($descriptionIconPosition, [IconPosition::Before, 'before'])): ?>
                        <?php if (isset($component)) { $__componentOriginalbfc641e0710ce04e5fe02876ffc6f950 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'filament::components.icon','data' => ['icon' => $descriptionIcon,'class' => $descriptionIconClasses,'style' => $descriptionIconStyles]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('filament::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($descriptionIcon),'class' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($descriptionIconClasses),'style' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($descriptionIconStyles)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950)): ?>
<?php $attributes = $__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950; ?>
<?php unset($__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbfc641e0710ce04e5fe02876ffc6f950)): ?>
<?php $component = $__componentOriginalbfc641e0710ce04e5fe02876ffc6f950; ?>
<?php unset($__componentOriginalbfc641e0710ce04e5fe02876ffc6f950); ?>
<?php endif; ?>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                        'fi-wi-stats-overview-stat-description text-sm',
                        $descriptionColor,
                    ]); ?>" style="<?php echo \Illuminate\Support\Arr::toCssStyles([
                        \Filament\Support\get_color_css_variables($descriptionColor, shades: [400, 600], alias: 'widgets::stats-overview-widget.stat.description') => $descriptionColor !== 'gray',
                    ]) ?>">
                        <?php echo e($description); ?>

                    </span>

                    <!--[if BLOCK]><![endif]--><?php if($descriptionIcon && in_array($descriptionIconPosition, [IconPosition::After, 'after'])): ?>
                        <?php if (isset($component)) { $__componentOriginalbfc641e0710ce04e5fe02876ffc6f950 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'filament::components.icon','data' => ['icon' => $descriptionIcon,'class' => $descriptionIconClasses,'style' => $descriptionIconStyles]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('filament::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($descriptionIcon),'class' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($descriptionIconClasses),'style' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($descriptionIconStyles)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950)): ?>
<?php $attributes = $__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950; ?>
<?php unset($__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbfc641e0710ce04e5fe02876ffc6f950)): ?>
<?php $component = $__componentOriginalbfc641e0710ce04e5fe02876ffc6f950; ?>
<?php unset($__componentOriginalbfc641e0710ce04e5fe02876ffc6f950); ?>
<?php endif; ?>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--[if BLOCK]><![endif]--><?php if($icon && $iconPosition === 'end'): ?>
            <div class="<?php echo e($iconContainerClasses); ?>">
                <?php if (isset($component)) { $__componentOriginalbfc641e0710ce04e5fe02876ffc6f950 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'filament::components.icon','data' => ['icon' => $icon,'class' => ''.e($iconClasses).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('filament::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($icon),'class' => ''.e($iconClasses).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950)): ?>
<?php $attributes = $__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950; ?>
<?php unset($__attributesOriginalbfc641e0710ce04e5fe02876ffc6f950); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbfc641e0710ce04e5fe02876ffc6f950)): ?>
<?php $component = $__componentOriginalbfc641e0710ce04e5fe02876ffc6f950; ?>
<?php unset($__componentOriginalbfc641e0710ce04e5fe02876ffc6f950); ?>
<?php endif; ?>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!--[if BLOCK]><![endif]--><?php if($chart = $getChart()): ?>
        
        <div x-data="{ statsOverviewStatChart: function() {} }">
            <div <?php if(FilamentView::hasSpaMode()): ?> ax-load="visible"
                <?php else: ?>
                    ax-load <?php endif; ?>
                ax-load-src="<?php echo e(\Filament\Support\Facades\FilamentAsset::getAlpineComponentSrc('stats-overview/stat/chart', 'filament/widgets')); ?>"
                x-data="statsOverviewStatChart({
                    dataChecksum: <?php echo \Illuminate\Support\Js::from($dataChecksum)->toHtml() ?>,
                    labels: <?php echo \Illuminate\Support\Js::from(array_keys($chart))->toHtml() ?>,
                    values: <?php echo \Illuminate\Support\Js::from(array_values($chart))->toHtml() ?>,
                })" class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                    'fi-wi-stats-overview-stat-chart inset-x-0 bottom-0 overflow-hidden rounded-b-xl',
                ]); ?>" style="<?php echo \Illuminate\Support\Arr::toCssStyles([
                    \Filament\Support\get_color_css_variables($chartColor, shades: [50, 400, 500], alias: 'widgets::stats-overview-widget.stat.chart') => $chartColor !== 'gray',
                ]) ?>">
                <canvas x-ref="canvas" height="60"></canvas>

                <span x-ref="backgroundColorElement" class="<?php echo \Illuminate\Support\Arr::toCssClasses([$chartBackgroundColor]); ?>"></span>

                <span x-ref="borderColorElement" class="<?php echo \Illuminate\Support\Arr::toCssClasses([$chartBorderColor]); ?>"></span>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </<?php echo $tag; ?>>
<?php /**PATH /home/soporxinfo365/public_html/produccion/vendor/eightynine/filament-advanced-widgets/src/../resources/views/advanced-stats-overview-widget/stat.blade.php ENDPATH**/ ?>